VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form frmDCMotors 
   Caption         =   "Motor control"
   ClientHeight    =   5475
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9030
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   5475
   ScaleWidth      =   9030
   Begin VB.CommandButton cmdSetSCoilPos 
      Caption         =   "S Coil"
      Height          =   252
      Left            =   5520
      TabIndex        =   53
      Top             =   1200
      Width           =   612
   End
   Begin VB.CommandButton cmdSetIRMHi 
      Caption         =   "IRM Hi"
      Height          =   252
      Left            =   5520
      TabIndex        =   52
      Top             =   840
      Width           =   735
   End
   Begin VB.CommandButton cmdSetIRMLo 
      Caption         =   "IRM Lo"
      Height          =   252
      Left            =   5520
      TabIndex        =   51
      Top             =   480
      Width           =   735
   End
   Begin VB.TextBox txtSpinRPS 
      Height          =   288
      Left            =   3480
      TabIndex        =   50
      Top             =   2760
      Width           =   612
   End
   Begin VB.CommandButton cmdSpinTurningMotor 
      Caption         =   "Spin Sample (rps):"
      Height          =   252
      Left            =   1920
      TabIndex        =   49
      Top             =   2760
      Width           =   1452
   End
   Begin VB.CommandButton cmdSetChangerHole 
      Caption         =   "Set Current Hole"
      Height          =   255
      Left            =   2400
      TabIndex        =   48
      Top             =   3360
      Width           =   1455
   End
   Begin VB.Frame frmActiveControls 
      Caption         =   "Active Controls"
      Height          =   1212
      Left            =   6360
      TabIndex        =   44
      Top             =   1320
      Width           =   1692
      Begin VB.OptionButton optMotorActive 
         Caption         =   "Up/Down"
         Enabled         =   0   'False
         Height          =   252
         Index           =   3
         Left            =   120
         TabIndex        =   47
         Top             =   720
         Width           =   1452
      End
      Begin VB.OptionButton optMotorActive 
         Caption         =   "Turning"
         Enabled         =   0   'False
         Height          =   252
         Index           =   2
         Left            =   120
         TabIndex        =   46
         Top             =   480
         Width           =   1452
      End
      Begin VB.OptionButton optMotorActive 
         Caption         =   "Changer"
         Enabled         =   0   'False
         Height          =   252
         Index           =   1
         Left            =   120
         TabIndex        =   45
         Top             =   240
         Width           =   1452
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Connections"
      Height          =   1092
      Left            =   6360
      TabIndex        =   40
      Top             =   120
      Width           =   1692
      Begin VB.CheckBox chkConnectMotor 
         Caption         =   "Up/Down"
         Height          =   252
         Index           =   3
         Left            =   120
         TabIndex        =   43
         Top             =   720
         Width           =   1452
      End
      Begin VB.CheckBox chkConnectMotor 
         Caption         =   "Turning"
         Height          =   252
         Index           =   2
         Left            =   120
         TabIndex        =   42
         Top             =   480
         Width           =   1452
      End
      Begin VB.CheckBox chkConnectMotor 
         Caption         =   "Changer"
         Height          =   252
         Index           =   1
         Left            =   120
         TabIndex        =   41
         Top             =   240
         Width           =   1452
      End
   End
   Begin VB.CommandButton cmdSampleDropOff 
      Caption         =   "Sample Dropoff"
      Height          =   255
      Left            =   120
      TabIndex        =   39
      Top             =   2040
      Width           =   1572
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      Height          =   372
      Left            =   480
      TabIndex        =   38
      Top             =   5040
      Width           =   1332
   End
   Begin VB.CommandButton buttonHeightSet 
      Caption         =   "Change Height:"
      Height          =   255
      Left            =   1920
      TabIndex        =   37
      Top             =   1080
      Width           =   1572
   End
   Begin VB.TextBox txtNewHeight 
      Height          =   285
      Left            =   3600
      TabIndex        =   36
      Text            =   "0"
      Top             =   1080
      Width           =   735
   End
   Begin VB.CommandButton RelabelPosButton 
      Caption         =   "Relabel P"
      Height          =   255
      Left            =   1320
      TabIndex        =   35
      Top             =   3360
      Width           =   975
   End
   Begin VB.CommandButton SetMeasButton 
      Caption         =   "Meas."
      Height          =   252
      Left            =   4800
      TabIndex        =   34
      Top             =   1560
      Width           =   612
   End
   Begin VB.CommandButton SetZeroButton 
      Caption         =   "Zero"
      Height          =   252
      Left            =   4800
      TabIndex        =   33
      Top             =   1200
      Width           =   612
   End
   Begin VB.CommandButton SetAfButton 
      Caption         =   "Af Coil"
      Height          =   252
      Left            =   4800
      TabIndex        =   32
      Top             =   840
      Width           =   612
   End
   Begin VB.CommandButton SetTopButton 
      Caption         =   "Top"
      Height          =   252
      Left            =   4800
      TabIndex        =   31
      Top             =   480
      Width           =   612
   End
   Begin VB.TextBox HoleTargetText 
      Height          =   285
      Left            =   3600
      TabIndex        =   29
      Text            =   "0"
      Top             =   2040
      Width           =   735
   End
   Begin VB.TextBox AngleTargetText 
      Height          =   285
      Left            =   3600
      TabIndex        =   28
      Text            =   "0"
      Top             =   1560
      Width           =   735
   End
   Begin VB.CommandButton ChangeHoleButton 
      Caption         =   "Change Hole:"
      Height          =   255
      Left            =   1920
      TabIndex        =   27
      Top             =   2040
      Width           =   1572
   End
   Begin VB.CommandButton ChangeTurnAngleButton 
      Caption         =   "Change Turn Angle:"
      Height          =   255
      Left            =   1920
      TabIndex        =   26
      Top             =   1560
      Width           =   1572
   End
   Begin VB.CommandButton ReadHoleButton 
      Caption         =   "Read hole"
      Height          =   252
      Left            =   7080
      TabIndex        =   25
      Top             =   4320
      Width           =   1332
   End
   Begin VB.CommandButton ReadAngleButton 
      Caption         =   "Read angle"
      Height          =   252
      Left            =   7080
      TabIndex        =   24
      Top             =   3960
      Width           =   1332
   End
   Begin VB.TextBox ChangerHoleBox 
      Height          =   285
      Left            =   5160
      TabIndex        =   22
      Top             =   4320
      Width           =   1812
   End
   Begin VB.TextBox TurningAngleBox 
      Height          =   285
      Left            =   5160
      TabIndex        =   20
      Top             =   3960
      Width           =   1812
   End
   Begin VB.TextBox txtPollPosition 
      Height          =   285
      Left            =   5160
      TabIndex        =   19
      Top             =   3600
      Width           =   1812
   End
   Begin VB.CommandButton ReadPosButton 
      Caption         =   "Read position"
      Height          =   252
      Left            =   7080
      TabIndex        =   17
      Top             =   3600
      Width           =   1332
   End
   Begin VB.CommandButton MotorResetButton 
      Caption         =   "Reset"
      Height          =   372
      Left            =   5640
      TabIndex        =   16
      Top             =   4800
      Width           =   852
   End
   Begin VB.CommandButton MotorHaltButton 
      BackColor       =   &H000000FF&
      Caption         =   "HALT!"
      Height          =   372
      Left            =   7680
      MaskColor       =   &H00FFFFFF&
      Style           =   1  'Graphical
      TabIndex        =   15
      Top             =   4800
      UseMaskColor    =   -1  'True
      Width           =   852
   End
   Begin VB.CommandButton MotorStopButton 
      Caption         =   "Stop"
      Height          =   372
      Left            =   6600
      TabIndex        =   14
      Top             =   4800
      Width           =   852
   End
   Begin VB.CommandButton ClearPollStatusButton 
      Caption         =   "Clear Poll Status"
      Height          =   492
      Left            =   2040
      TabIndex        =   13
      Top             =   3720
      Width           =   852
   End
   Begin VB.CommandButton PollMotorButton 
      Caption         =   "Poll Motor"
      Height          =   372
      Left            =   840
      TabIndex        =   12
      Top             =   3840
      Width           =   852
   End
   Begin VB.TextBox MoveMotorVelocityEdit 
      Height          =   285
      Left            =   2880
      TabIndex        =   9
      Text            =   "4000000"
      Top             =   600
      Width           =   975
   End
   Begin VB.CommandButton ZeroTargetPosButton 
      Caption         =   "Zero T/P"
      Height          =   255
      Left            =   240
      TabIndex        =   8
      Top             =   3360
      Width           =   975
   End
   Begin VB.CommandButton SamplePickupButton 
      Caption         =   "Sample Pickup"
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   1560
      Width           =   1572
   End
   Begin VB.CommandButton HomeToTopButton 
      Caption         =   "Home to Top"
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   1080
      Width           =   1572
   End
   Begin VB.TextBox MoveMotorPosEdit 
      Height          =   285
      Left            =   1920
      TabIndex        =   5
      Text            =   "0"
      Top             =   600
      Width           =   735
   End
   Begin VB.CommandButton MoveMotorButton 
      Caption         =   "Move to Position:"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   600
      Width           =   1572
   End
   Begin VB.TextBox txtInputText 
      Height          =   285
      Left            =   5160
      TabIndex        =   2
      Top             =   3240
      Width           =   3015
   End
   Begin VB.TextBox OutputText 
      Height          =   285
      Left            =   5160
      TabIndex        =   0
      Top             =   2760
      Width           =   3015
   End
   Begin MSCommLib.MSComm MSCommMotor 
      Index           =   3
      Left            =   2880
      Top             =   4920
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin MSCommLib.MSComm MSCommMotor 
      Index           =   1
      Left            =   3600
      Top             =   4920
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin MSCommLib.MSComm MSCommMotor 
      Index           =   2
      Left            =   4440
      Top             =   4920
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin VB.Label Label5 
      Caption         =   "Set position"
      Height          =   252
      Left            =   4800
      TabIndex        =   30
      Top             =   120
      Width           =   1212
   End
   Begin VB.Label Label4 
      Caption         =   "Last Hole Read"
      Height          =   252
      Left            =   3840
      TabIndex        =   23
      Top             =   4320
      Width           =   1332
   End
   Begin VB.Label Label3 
      Caption         =   "Last Turn Angle"
      Height          =   252
      Left            =   3840
      TabIndex        =   21
      Top             =   3960
      Width           =   1332
   End
   Begin VB.Label Label6 
      Caption         =   "Last Pos Read"
      Height          =   252
      Left            =   3840
      TabIndex        =   18
      Top             =   3600
      Width           =   1332
   End
   Begin VB.Label Label13 
      Caption         =   "Velocity"
      Height          =   252
      Left            =   2880
      TabIndex        =   11
      Top             =   240
      Width           =   972
   End
   Begin VB.Label Label12 
      Alignment       =   2  'Center
      Caption         =   "Target Pos"
      Height          =   372
      Left            =   1920
      TabIndex        =   10
      Top             =   120
      Width           =   612
   End
   Begin VB.Label Label2 
      Caption         =   "Input:"
      Height          =   252
      Left            =   4560
      TabIndex        =   3
      Top             =   3240
      Width           =   492
   End
   Begin VB.Label Label1 
      Caption         =   "Output:"
      Height          =   252
      Left            =   4440
      TabIndex        =   1
      Top             =   2760
      Width           =   612
   End
End
Attribute VB_Name = "frmDCMotors"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Const MotorChanger As Integer = 1
Const MotorTurning As Integer = 2
Const MotorUpDown As Integer = 3
Const lastCmdMove As Integer = 1
Const lastCmdDropoff As Integer = 2
Const lastCmdPickup As Integer = 3
Dim MotorsLocked As Integer
Private InputText(3) As String
Private lastPosition(3) As Long
Public lastMoveCommand As Integer
Public lastMoveMotor As Integer
Public lastMoveTarget As Long
Private currenthole As Double
Private ComPortAssignments(3) As Integer
Private OverlappingComPorts As Boolean
Dim UpDownSpeeds(2) As Long

Private Sub cmdSetIRMHi_Click()
    MoveMotorPosEdit.Text = Str(IRMHiPos)
    txtNewHeight = Str(IRMHiPos)
End Sub

Private Sub cmdSetIRMLo_Click()
    MoveMotorPosEdit.Text = Str(IRMPos)
    txtNewHeight = Str(IRMPos)
End Sub

Private Sub cmdSetSCoilPos_Click()
    MoveMotorPosEdit.Text = Str(SCoilPos)
    txtNewHeight = Str(SCoilPos)
End Sub

Private Sub form_resize()
    Me.Height = 5880
    Me.Width = 9150
End Sub

Public Sub AssignCommPorts()
    OverlappingComPorts = False
    ComPortAssignments(MotorChanger) = MotorChanger
    If COMPortTurning = COMPortChanger Then
        ComPortAssignments(MotorTurning) = ComPortAssignments(MotorChanger)
        OverlappingComPorts = True
    Else
        ComPortAssignments(MotorTurning) = MotorTurning
    End If
    If COMPortUpDown = COMPortChanger Then
        ComPortAssignments(MotorUpDown) = ComPortAssignments(MotorChanger)
        OverlappingComPorts = True
    ElseIf COMPortUpDown = COMPortTurning Then
        ComPortAssignments(MotorUpDown) = ComPortAssignments(MotorTurning)
        OverlappingComPorts = True
    Else
        ComPortAssignments(MotorUpDown) = MotorUpDown
    End If
End Sub

Public Sub ResumeMove()
    Select Case lastMoveCommand
    Case lastCmdPickup
        SamplePickup
    Case lastCmdDropoff
        SampleDropOff
    Case lastCmdMove
        Select Case lastMoveMotor
        Case MotorChanger
            ChangerMotortoHole lastMoveTarget
        Case MotorTurning
            TurningMotorRotate lastMoveTarget
        Case MotorUpDown
            UpDownMove lastMoveTarget, 0
        End Select
    End Select
End Sub

Private Function MotorCOMPort(Optional motorid As Integer = MotorTurning) As Integer
    Select Case motorid
    Case MotorChanger
        MotorCOMPort = COMPortChanger
    Case MotorTurning
        MotorCOMPort = COMPortTurning
    Case MotorUpDown
        MotorCOMPort = COMPortUpDown
    Case Else
        MotorCOMPort = COMPortTurning
    End Select
End Function

Private Function MotorAddress(Optional motorid As Integer = MotorTurning) As String
    Select Case motorid
    Case MotorChanger
        MotorAddress = MotorIDChanger
    Case MotorTurning
        MotorAddress = MotorIDTurning
    Case MotorUpDown
        MotorAddress = MotorIDUpDown
    Case Else
        MotorAddress = MotorIDTurning
    End Select
    MotorAddress = "@" & Str(MotorIDUpDown) & " "
End Function

Private Sub SetSCurveNext(motorid As Integer, sValue As Integer)
    ' full S curve is 32767
    'SendCommand motorid, MotorAddress(motorid) & "195 " + Str(sValue)
    'GetResponse (motorid)
End Sub

Private Sub buttonHeightSet_Click()
    UpDownMove txtNewHeight, 0
End Sub

Private Sub ChangeHoleButton_Click()
    ChangerMotortoHole val(HoleTargetText)
End Sub

Private Sub ChangeTurnAngleButton_Click()
    TurningMotorRotate val(AngleTargetText)
End Sub

Private Sub chkConnectMotor_Click(Index As Integer)
    If chkConnectMotor(Index) Then
        MotorCommConnect Index
    Else
        MotorCommDisconnect Index
    End If
End Sub

Private Sub cmdClose_Click()
    Me.Hide
End Sub

Private Sub cmdSampleDropOff_Click()
    SampleDropOff pauseOverride:=True
End Sub

Private Sub cmdSetChangerHole_Click()
    SetChangerHole val(HoleTargetText)
End Sub

Private Sub cmdSpinTurningMotor_Click()
    TurningMotorSpin val(txtSpinRPS), pauseOverride:=True
End Sub

Private Sub ReadAngleButton_Click()
    Dim dummy As Double
    dummy = TurningMotorAngle()
End Sub

Private Sub MotorHaltButton_Click()
    MotorHalt ActiveMotorControls
End Sub

Private Sub MotorResetButton_Click()
    MotorReset ActiveMotorControls
End Sub

Private Sub MotorStopButton_Click()
    MotorStop ActiveMotorControls
End Sub

Public Sub MotorStop(Optional motorid As Integer = 0)
    If motorid = 0 Then
        LockMotor 0
        MotorStop MotorUpDown
        MotorStop MotorChanger
        MotorStop MotorTurning
        Exit Sub
    End If
    LockMotor 0
    SendCommand motorid, MotorAddress(motorid) & "3 0"
    GetResponse (motorid)
End Sub

Public Sub MotorHalt(Optional motorid As Integer = 0)
    If motorid = 0 Then
        LockMotor 0
        MotorHalt MotorUpDown
        MotorHalt MotorChanger
        MotorHalt MotorTurning
        Exit Sub
    End If
    LockMotor 0
    SendCommand motorid, MotorAddress(motorid) & "2"
    GetResponse (motorid)
End Sub

Public Sub MotorReset(Optional motorid As Integer = 0)
    If motorid = 0 Then
        LockMotor 0
        MotorReset MotorUpDown
        MotorReset MotorChanger
        MotorReset MotorTurning
        Exit Sub
    End If
    SendCommand motorid, MotorAddress(motorid) & "4"
    GetResponse (motorid)
End Sub

Private Sub ReadHoleButton_Click()
    Dim dummy As Double
    dummy = ChangerHole()
End Sub

Private Sub ReadPosButton_Click()
    Dim dummy As Long
    dummy = ReadPosition(ActiveMotorControls)
End Sub

Private Sub RelabelPosButton_Click()
    RelabelPos ActiveMotorControls, (val(MoveMotorPosEdit))
End Sub

Private Sub SetTopButton_click()
    ' Set the value of the place to move to the top
    MoveMotorPosEdit.Text = "0"
    txtNewHeight = "0"
End Sub

Private Sub SetAfButton_click()
    Dim dummystring As String
    ' Set the value of the place to move to the center of the Af coils
    MoveMotorPosEdit.Text = Str(AFPos)
    txtNewHeight = Str(AFPos)
End Sub
Private Sub SetZeroButton_click()
    ' Set the value of the place to move to the measurement Zero position
    MoveMotorPosEdit.Text = Str(ZeroPos)
    txtNewHeight = Str(ZeroPos)
End Sub

Private Sub SetMeasButton_click()
    ' Set the value of the place to move to the center of the Af coils
    MoveMotorPosEdit.Text = Str(Int(MeasPos + SampleHeight / 2))
    txtNewHeight = MoveMotorPosEdit.Text
End Sub

Private Function ReadPosition(motorid As Integer) As Long
    Dim hexpos As String
    Dim decpos As Long
    ' If we have an error, we'll report the last position read
    decpos = lastPosition(motorid)
    SendCommand motorid, MotorAddress(motorid) & "12 1"
    GetResponse motorid
    If Len(InputText(motorid)) = 20 Then
        hexpos = Mid(InputText(motorid), 11, 4) + Mid(InputText(motorid), 16, 4)
        decpos = CLng("&H" + hexpos)
    End If
    txtPollPosition = decpos
    lastPosition(motorid) = decpos
    ReadPosition = decpos
End Function

Public Function ConvertPosToHole(pos As Long) As Double
    Dim hole As Double
    Dim FullLoop As Double
    FullLoop = (SlotMax - SlotMin + 1)
    hole = (pos / OneStep) Mod FullLoop
    If hole <= 0 Then hole = hole + (SlotMax - SlotMin + 1)
    ConvertPosToHole = hole
End Function

Public Function ConvertHoletoPos(hole As Double) As Long
    Dim currenthole As Double
    Dim currentPos As Long
    Dim TargetHolePosRaw As Long
    Dim TargetHole As Double
    Dim FullLoop As Double
    Dim StepsToGo As Double
    FullLoop = Abs((SlotMax - SlotMin + 1) * OneStep)
    currentPos = ReadPosition(MotorChanger)
    currenthole = ChangerHole()
    TargetHole = hole
    TargetHolePosRaw = OneStep * hole
    StepsToGo = (TargetHolePosRaw - currentPos) Mod FullLoop
    If Abs(StepsToGo) > (FullLoop / 2) Then
        If StepsToGo > 0 Then
            StepsToGo = StepsToGo - FullLoop
        Else
            StepsToGo = StepsToGo + FullLoop
        End If
    End If
    If Not Changer_isHole(TargetHole) Then
        If StepsToGo > 0 Then
            StepsToGo = StepsToGo + SampleHoleAlignmentOffset * OneStep
        Else
            StepsToGo = StepsToGo + SampleHoleAlignmentOffset * OneStep
        End If
    End If
    ConvertHoletoPos = Int(StepsToGo + currentPos)
End Function

Public Sub RelabelPos(motorid As Integer, pos As Long)
    Do Until Abs(ReadPosition(motorid) - pos) < 10
        ZeroTargetPos motorid
        ' @16 11 10 num 'load register
        SendCommand motorid, (MotorAddress & "11 10 " & Str(-pos))
        GetResponse motorid
        ' @16 165 1802 ' subtract register 10 from T&P
        SendCommand motorid, (MotorAddress & "165 1802")
        GetResponse motorid
    Loop
End Sub

Public Function ConvertPosToAngle(pos As Long) As Double
    ConvertPosToAngle = (pos / -TurningMotorFullRotation) * 360
End Function

Public Function ConvertAngleToPos(angle As Double) As Long
    ConvertAngleToPos = Int(-TurningMotorFullRotation * angle / 360)
End Function

Public Sub ChangerMotortoHole(ByVal hole As Double, Optional ByVal waitingForStop As Boolean = True, Optional ByVal pauseOverride As Boolean = True)
    Dim curhole As Double
    Dim startinghole As Double
    Dim startingPos As Double
    Dim curpos As Long
    Dim FullLoop As Long
    Dim target As Long
    Dim errormessage As String
    If Not Prog_paused Or Prog_halted Then
        lastMoveCommand = lastCmdMove
        lastMoveMotor = MotorChanger
        lastMoveTarget = hole
    End If
    ' Let's get the sample rod out of the way if necessary
    If Abs(UpDownHeight) > Abs(SampleBottom) * 0.1 Then HomeToTop
    FullLoop = (SlotMax - SlotMin + 1) * OneStep
    startingPos = ReadPosition(MotorChanger)
    curpos = startingPos
    If curpos \ FullLoop <> 0 Then RelabelPos MotorChanger, (curpos Mod FullLoop)
    startinghole = ChangerHole
    target = ConvertHoletoPos(hole)
    SetSCurveNext MotorChanger, SCurveFactor
    MoveMotor MotorChanger, target, ChangerSpeed, waitingForStop, pauseOverride
    If Not waitingForStop Then Exit Sub
    curpos = ReadPosition(MotorChanger)
    If curpos \ FullLoop <> 0 Then RelabelPos MotorChanger, (curpos Mod FullLoop)
    If NOCOMM_MODE Then currenthole = hole
    curhole = ChangerHole
    'Because OneStep is negative, the criteria was never reach (always <0 and not >0.02) till the asolute value (May 2007 L Carporzen)
    If Not NOCOMM_MODE And (Abs(curpos - target) / Abs(OneStep)) > 0.02 Then
        ' First try to move to move back to the desired position
        SetSCurveNext MotorChanger, SCurveFactor
        MoveMotor MotorChanger, target, 0.5 * ChangerSpeed, pauseOverride:=True
        curpos = ReadPosition(MotorChanger)
    End If
    '  Quit if fail here, backing off a bit first ...
    If Not NOCOMM_MODE And (Abs(curpos - target) / Abs(OneStep)) > 0.02 Then
        errormessage = "Unacceptable slop moving changer" & vbCrLf & _
            "from hole " & Str(startinghole) & " to hole " & Str(hole) & "." & _
            vbCrLf & vbCrLf & "Target position: " & Str(target) & vbCrLf & _
            "Current position: " & Str(curpos) & vbCrLf & vbCrLf & _
            "Execution has been paused. Please check machine."
        SetSCurveNext MotorChanger, SCurveFactor
        MoveMotor MotorChanger, (curpos - (curpos - startingPos) * 0.1), 0.1 * ChangerSpeed, pauseOverride:=True
        DelayTime 0.2
        Flow_Pause
        SetCodeLevel CodeRed
        frmSendMail.MailNotification "Unacceptable slop", errormessage, CodeRed
        MsgBox errormessage
        SetCodeLevel StatusCodeColorLevelPrior, True
    End If
End Sub

Public Sub TurningMotorRotate(ByVal angle As Double, Optional ByVal waitingForStop As Boolean = True, Optional ByVal pauseOverride As Boolean = True)
    Dim curangle As Double
    Dim startingangle As Double
    Dim startingPos As Long
    Dim target As Long
    Dim curpos As Long
    Dim errormessage As String
    If Prog_halted Then Exit Sub
    If Not Prog_paused Or Prog_halted Then
        lastMoveCommand = lastCmdMove
        lastMoveMotor = MotorTurning
        lastMoveTarget = angle
    End If
    startingPos = ReadPosition(MotorTurning)
    startingangle = TurningMotorAngle
    target = ConvertAngleToPos(angle)
    SetSCurveNext MotorTurning, SCurveFactor
    MoveMotor MotorTurning, target, TurnerSpeed, waitingForStop, pauseOverride
    If Not waitingForStop Then Exit Sub
    curangle = TurningMotorAngle
    If Not NOCOMM_MODE And (Abs((curangle - angle) Mod 360) > 1) Then
        ' First try to move to move back to the desired position
        MoveMotor MotorTurning, startingPos, TurnerSpeed, pauseOverride:=True
        curpos = ReadPosition(MotorTurning)
        SetSCurveNext MotorTurning, SCurveFactor
        MoveMotor MotorTurning, target, TurnerSpeed, pauseOverride:=True
        curangle = TurningMotorAngle
    End If
    ' Quit here if this is bad ...
    If Not NOCOMM_MODE And (Abs((curangle - angle) Mod 360) > 3) Then
        curpos = ReadPosition(MotorTurning)
        errormessage = "Unacceptable slop on turning motor from" & vbCrLf & _
            Str(startingangle) & "degrees to " & Str(angle) & " degrees." & _
            vbCrLf & vbCrLf & "Target position: " & Str(target) & vbCrLf & _
            "Current position: " & Str(curpos) & vbCrLf & vbCrLf & _
            "Execution has been paused. Please check machine."
        SetSCurveNext MotorTurning, SCurveFactor
        MoveMotor MotorTurning, (curpos - (curpos - startingPos) * 0.1), 0.1 * TurnerSpeed, pauseOverride:=True
        DelayTime 0.2
        Flow_Pause
        SetCodeLevel CodeRed
        frmSendMail.MailNotification "Unacceptable slop", errormessage, CodeRed
        MsgBox errormessage
        SetCodeLevel StatusCodeColorLevelPrior, True
    End If
    curangle = TurningMotorAngle
    curangle = curangle - (curangle \ 360) * 360
    If curangle <> TurningMotorAngle Then SetTurningMotorAngle curangle
End Sub

Public Sub TurningMotorSpin(ByVal speedRPS As Double, Optional ByVal duration As Double = 60, Optional ByVal pauseOverride As Boolean = False)
    Dim curangle As Double
    Dim startingangle As Double
    Dim startingPos As Long
    Dim target As Long
    Dim curpos As Long
    Dim errormessage As String
    Dim activeAngle As Double
    If Prog_halted Then Exit Sub
'    If Not Prog_paused Or Prog_halted Then
'        lastMoveCommand = lastCmdMove
'        lastMoveMotor = MotorTurning
'        lastMoveTarget = angle
'    End If
    If speedRPS = 0 Then
        MotorStop MotorTurning
        activeAngle = TurningMotorAngle
        curangle = activeAngle - (activeAngle \ 360) * 360
        If curangle <> activeAngle Then SetTurningMotorAngle curangle
        activeAngle = TurningMotorAngle
        If curangle <> activeAngle Then SetTurningMotorAngle curangle
        If Abs(curangle) > 10 Then
            target = 360
        Else
            target = 0
        End If
        TurningMotorRotate target
        WaitForMotorStop MotorTurning
        SetTurningMotorAngle 0
        curangle = TurningMotorAngle
    Else
        startingPos = ReadPosition(MotorTurning)
        startingangle = TurningMotorAngle
        target = startingPos - TurningMotorFullRotation * speedRPS * duration
        SetSCurveNext MotorTurning, SCurveFactor
        MoveMotor MotorTurning, target, Abs(TurningMotor1rps * speedRPS), False, pauseOverride
    End If
End Sub

Public Sub SetTurningMotorAngle(angle As Double)
    Dim pos As Long
    pos = ConvertAngleToPos(angle)
    RelabelPos MotorTurning, pos
    If TurningMotorAngle <> angle Then RelabelPos MotorTurning, pos
End Sub

Public Function TurningMotorAngle() As Double
    Dim angle As Double
    angle = ConvertPosToAngle(ReadPosition(MotorTurning))
    TurningAngleBox = angle
    TurningMotorAngle = angle
End Function

Public Function ChangerHole() As Double
    Dim curhole As Double
    Dim curpos As Long
    If NOCOMM_MODE Then
        ChangerHole = currenthole
    Else
        curpos = ReadPosition(MotorChanger)
        curhole = ConvertPosToHole(curpos)
        currenthole = curhole
        ChangerHoleBox = curhole
        ChangerHole = curhole
    End If
End Function

Public Sub UpDownMove(ByVal Position As Long, ByVal speed As Integer, Optional ByVal waitingForStop As Boolean = True, Optional ByVal pauseOverride = False)
    Dim startingPos As Long
    Dim errormessage As String
    Dim curpos As Long
    Dim movementSign As Integer
    If Prog_halted Then Exit Sub
    If Not Prog_paused Or Prog_halted Then
        lastMoveCommand = lastCmdMove
        lastMoveMotor = MotorUpDown
        lastMoveTarget = Position
    End If
    startingPos = ReadPosition(MotorUpDown)
    If Position < curpos Then
        movementSign = -1
    Else
        movementSign = 1
    End If
    UpDownSpeeds(0) = LiftSpeedSlow
    UpDownSpeeds(1) = LiftSpeedNormal
    UpDownSpeeds(2) = LiftSpeedFast
    SetSCurveNext MotorUpDown, SCurveFactor
    MoveMotor MotorUpDown, Position, UpDownSpeeds(speed), waitingForStop, pauseOverride
    If Not waitingForStop Then Exit Sub
    curpos = ReadPosition(MotorUpDown)
    ' back off a bit and try again if off
    If Not NOCOMM_MODE And Abs(curpos - Position) > 100 And Position <> 0 Then
        SetSCurveNext MotorUpDown, SCurveFactor
        MoveMotor MotorUpDown, (curpos + startingPos) / 2, LiftSpeedSlow, pauseOverride:=True
        SetSCurveNext MotorUpDown, SCurveFactor
        MoveMotor MotorUpDown, Position, UpDownSpeeds(speed), pauseOverride:=True
        curpos = ReadPosition(MotorUpDown)
    End If
    ' quit here if this is bad
    If Not NOCOMM_MODE And (Abs(curpos - Position) > 150) And Position <> 0 Then
        errormessage = "Unacceptable slop on up/down motor moving from" & vbCrLf & _
            Str(startingPos) & " to " & Str(Position) & " at speed " & Str(speed) & "." & _
            vbCrLf & vbCrLf & "Target position: " & Str(Position) & vbCrLf & _
            "Current position: " & Str(curpos) & vbCrLf & vbCrLf & _
            "Execution has been paused. Please check machine."
        MoveMotor MotorUpDown, (curpos - 100 * movementSign), 0.5 * LiftSpeedSlow, pauseOverride:=True
        DelayTime 0.2
        Flow_Pause
        MotorStop MotorUpDown
        SetCodeLevel CodeRed
        frmSendMail.MailNotification "Unacceptable slop", errormessage, CodeRed
        MsgBox errormessage
        SetCodeLevel StatusCodeColorLevelPrior, True
    End If
End Sub

Public Function UpDownHeight() As Double
    UpDownHeight = ReadPosition(MotorUpDown)
End Function

Public Sub MotorCommDisconnect(Optional ByVal motorid As Integer = 0)
    If Not (motorid = MotorTurning Or motorid = MotorChanger Or motorid = MotorUpDown) Then
        MotorCommDisconnect MotorTurning
        MotorCommDisconnect MotorChanger
        MotorCommDisconnect MotorUpDown
        AssignCommPorts
        Exit Sub
    End If
    If MSCommMotor(ComPortAssignments(motorid)).PortOpen Then
        MSCommMotor(ComPortAssignments(motorid)).InBufferCount = 0
        MSCommMotor(ComPortAssignments(motorid)).OutBufferCount = 0
        MSCommMotor(ComPortAssignments(motorid)).PortOpen = False
        chkConnectMotor(ComPortAssignments(motorid)).Value = Unchecked
        optMotorActive(ComPortAssignments(motorid)).Enabled = False
    End If
End Sub

Private Sub MotorCommConnect(motorid As Integer)
    If MSCommMotor(ComPortAssignments(motorid)).PortOpen = False And Not NOCOMM_MODE Then
        On Error GoTo ErrorHandler  ' Enable error-handling routine.
        MSCommMotor(ComPortAssignments(motorid)).CommPort = MotorCOMPort(motorid)
        MSCommMotor(ComPortAssignments(motorid)).Settings = "57600,N,8,2"
        MSCommMotor(ComPortAssignments(motorid)).SThreshold = 1
        MSCommMotor(ComPortAssignments(motorid)).RThreshold = 0
        MSCommMotor(ComPortAssignments(motorid)).inputlen = 1
        MSCommMotor(ComPortAssignments(motorid)).PortOpen = True
        On Error GoTo 0 ' Turn off error trapping.
        If MSCommMotor(ComPortAssignments(motorid)).PortOpen = True Then
            chkConnectMotor(motorid).Value = Checked
            ' Set an Ack Delay of 50 msec
            SendCommand motorid, ("@255 173 416") '50 msec delay
            If motorid = MotorUpDown Then SetTorques MotorUpDown, UpDownTorqueFactor, UpDownTorqueFactor, UpDownTorqueFactor, UpDownTorqueFactor
            ReadPosition (motorid)
            optMotorActive(motorid).Enabled = True
        Else
            chkConnectMotor(motorid).Value = Unchecked
            optMotorActive(motorid).Enabled = False
            If Not NOCOMM_MODE Then MsgBox "Motor Comm port not open in connection routine."
        End If
    End If
Exit Sub        ' Exit to avoid handler.
ErrorHandler:   ' Error-handling routine.
    Select Case Err.number  ' Evaluate error number.
        Case 8002
            MsgBox "Invalid Port Number"
        Case 8005
            MsgBox "Port already open" + Chr(13) + "(Already is use?)"
        Case 8010
            MsgBox "The hardware is not available (locked by another device)"
        Case 8012
            MsgBox "The device is not open"
        Case 8013
            MsgBox "The device is already open"
        Case Else
            MsgBox "Unknown error trying to Connect Comm Port"
    End Select
End Sub

Private Sub Form_Load()
    MotorsLocked = False
    AssignCommPorts
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Dim i As Integer
    For i = 1 To 3
        If MSCommMotor(i).PortOpen = True Then
            MSCommMotor(i).PortOpen = False
        End If
    Next i
End Sub

Private Function IsValidMotorid(motorid As Integer)
    IsValidMotorid = False
    If motorid = MotorTurning Or motorid = MotorChanger Or motorid = MotorUpDown Then
        IsValidMotorid = True
    End If
End Function

Private Sub SendCommand(motorid As Integer, outstring As String)
    If Not IsValidMotorid(motorid) Then Exit Sub
    optMotorActive(motorid).Value = True
    If MSCommMotor(motorid).PortOpen = False Then MotorCommConnect motorid
    If OverlappingComPorts Then
        Do While ((MotorsLocked <> 0) And (MotorsLocked <> motorid))
            DelayTime 0.05
        Loop
        LockMotor motorid
    End If
    If MSCommMotor(motorid).PortOpen = True Then
        MSCommMotor(motorid).RTSEnable = True
        MSCommMotor(motorid).InBufferCount = 0
        MSCommMotor(motorid).OutBufferCount = 0
        MSCommMotor(motorid).Output = outstring + vbCrLf
        OutputText = outstring
        'If DEBUG_MODE Then frmDebug.Msg "COM " & Str$(MSCommMotor(motorid).CommPort) & "out: " & outstring
    Else
        If Not NOCOMM_MODE Then MsgBox "Motor Comm Port Not Open sending " + outstring + " to comm port " + Str(MSCommMotor(motorid).CommPort)
    End If
    If OverlappingComPorts Then LockMotor 0
End Sub

Private Function GetResponse(motorid As Integer) As Boolean
    Dim Delay As Double
    Dim inputchar As String
    If Not IsValidMotorid(motorid) Then Exit Function
    If MSCommMotor(motorid).PortOpen = False Then
        MotorCommConnect motorid
    End If
    Delay = Timer   ' Set delaystart time.
    inputchar = vbNullString
    Do While (Not NOCOMM_MODE) And Right$(inputchar, 1) <> vbCr
        DoEvents
        If MSCommMotor(motorid).InBufferCount > 0 Then
            inputchar = inputchar + MSCommMotor(motorid).Input
        End If
        If Timer < Delay Then Delay = Delay - 86400
        If Timer - Delay > 0.3 Then
            'MsgBox "Timeout sending motor command"
            Exit Do
        End If
    Loop
    InputText(motorid) = inputchar
    txtInputText = inputchar
    'If DEBUG_MODE Then frmDebug.Msg "COM " & Str$(MSCommMotor(motorid).CommPort) & "in: " & inputchar
    'We return true if any of the bits 12-15 are set in the polling status word, false otherwise
    'If these bits are set (especially bits 13 and 15, we know that a move has been completed
    If (Left$(inputchar, 1) = "#") Then
        inputchar = Mid$(inputchar, 11)
        If (inputchar <> "0") Then
            GetResponse = True
        Else
            GetResponse = False
        End If
    Else
        GetResponse = False
    End If
    If NOCOMM_MODE Then GetResponse = True
End Function

Public Sub SetChangerHole(hole As Double)
    If Changer_ValidStart(hole) Then
        RelabelPos MotorChanger, (ConvertHoletoPos(hole))
        currenthole = hole
        ChangerHole
    End If
End Sub

Private Function PollMotor(motorid As Integer) As String
    'Poll the motor once
    SendCommand motorid, (MotorAddress & "0")
    GetResponse motorid
End Function

Private Sub ClearPollStatus(motorid As Integer)
    'Clear the polling status
    SendCommand motorid, (MotorAddress & "1 65535")
    GetResponse motorid
End Sub

Private Sub PollMotorButton_Click()
    PollMotor ActiveMotorControls
End Sub

Private Sub ClearPollStatusButton_Click()
    ClearPollStatus ActiveMotorControls
End Sub

Private Sub WaitForMotorStop(motorid As Integer, Optional pauseOveride As Boolean = False)
    Dim finished As Boolean
    Dim dummy As Boolean
    Dim curmotor As String
    Dim PollPosition As Long
    Dim oldPosition(1) As Long
    Dim pausedInitial As Boolean
    oldPosition(0) = 2 ^ 7
    oldPosition(1) = -2 ^ 7
    pausedInitial = Prog_paused
    frmProgram.StatusBar "Wait for stop...", 2
    'Now wait for motor to indicate that it is finished before continuing
    'We do this by polling the motor repeatedly until the appropriate bit is set in the polling word
    Do While ((finished = False))
        'having this delay inside the do loop instead of outside
        'appears to fix early drop program (according to Scott)
        DelayTime 0.05
        DoEvents
        If Not pauseOveride Then Flow_WaitForUnpaused
        oldPosition(1) = oldPosition(0)
        oldPosition(0) = PollPosition
        frmProgram.StatusBar Str$(oldPosition(0)), 3
        Select Case motorid
            Case MotorUpDown: dummy = Str(UpDownHeight)
            Case MotorTurning: dummy = Str(TurningMotorAngle)
            Case MotorChanger: dummy = Str(ChangerHole)
        End Select
        PollPosition = ReadPosition(motorid)
        ' if we're not moving, we're done
        If oldPosition(1) = oldPosition(0) And oldPosition(0) = PollPosition Then
            finished = True
        ElseIf (Abs(oldPosition(1) - oldPosition(0)) < 5) And (Abs(oldPosition(0) - PollPosition) < 5) Then
            finished = True
        End If
        If finished Then frmProgram.StatusBar "Stopped", 2
    Loop
    frmProgram.StatusBar vbNullString, 2
    frmProgram.StatusBar vbNullString, 3
    MotorStop ' just make sure we're really stopped
End Sub

Private Sub LockMotor(motorid As Integer)
    If IsValidMotorid(motorid) Then
        MotorsLocked = motorid
    Else
        MotorsLocked = 0
    End If
End Sub

Private Sub MoveMotor(motorid As Integer, MoveMotorPos As Long, MoveMotorVelocity As Long, Optional waitingForStop As Boolean = True, Optional ByVal pauseOverride As Boolean = False)
    Do While ((MotorsLocked <> 0) And (MotorsLocked <> motorid))
        DelayTime 0.05
    Loop
    If DEBUG_MODE Then frmDebug.Msg "Motor " & Str$(motorid) & " to " & Str$(MoveMotorPos) & " at " & Str$(MoveMotorVelocity)
    LockMotor motorid
    MoveMotorPosEdit = Str(MoveMotorPos)
    MoveMotorVelocityEdit = Str(MoveMotorVelocity)
    PollMotor motorid
    ClearPollStatus motorid
    SendCommand motorid, (MotorAddress(motorid) & "134 " + MoveMotorPosEdit + " 96637 " + MoveMotorVelocityEdit + " 0 0")
    GetResponse motorid
    If waitingForStop Then WaitForMotorStop motorid, pauseOverride
    LockMotor 0
End Sub

Private Sub MoveMotorButton_Click()
    MoveMotor ActiveMotorControls, val(MoveMotorPosEdit), val(MoveMotorVelocityEdit), pauseOverride:=True
End Sub

Public Function HomeToTop(Optional pauseOveride As Boolean = False) As Long
    Dim offset As Integer
    Dim speed As Long
    If Prog_halted Then Exit Function
    ' if switch already tripped, do nothing
    If CheckInternalStatus(MotorUpDown, 4) = 1 Then Exit Function
    Do While ((MotorsLocked <> 0) And (MotorsLocked <> MotorUpDown))
        DelayTime 0.05
    Loop
    LockMotor MotorUpDown
    If Abs(ReadPosition(MotorUpDown)) > Abs(SampleBottom) Then
        speed = LiftSpeedNormal
    Else
        speed = 0.25 * (LiftSpeedNormal + 3 * LiftSpeedSlow)
    End If
    MoveMotor MotorUpDown, -2 * MeasPos, speed, True, pauseOveride
    If Not CheckInternalStatus(MotorUpDown, 4) = 1 Then MoveMotor MotorUpDown, -2 * MeasPos, LiftSpeedSlow, True, pauseOveride
    If Not CheckInternalStatus(MotorUpDown, 4) = 1 And Not NOCOMM_MODE Then
        SetCodeLevel CodeRed
        frmSendMail.MailNotification "Homing error!", "Homed to top but did not hit switch.", CodeRed
        MsgBox "Homed to top but did not hit switch!"
        SetCodeLevel StatusCodeColorLevelPrior, True
    End If
    HomeToTop = ReadPosition(MotorUpDown)
    ZeroTargetPos MotorUpDown ' (September 2007) previously MotorReset MotorUpDown
    LockMotor 0
End Function

Public Function CheckInternalStatus(motorid As Integer, bit As Integer) As Integer
    Dim inputchar As String, hexpos As String
    Dim decpos As Long
    SendCommand MotorUpDown, (MotorAddress(MotorUpDown) & "20")
    GetResponse MotorUpDown
    inputchar = InputText(motorid)
    CheckInternalStatus = -1
    If Len(inputchar) = 15 Then
        hexpos = Mid$(inputchar, 11, 4)
        decpos = CLng("&H" + hexpos)
    Else
        Exit Function
    End If
    decpos = (decpos \ 2 ^ (bit)) Mod 2
    CheckInternalStatus = decpos
End Function

Private Sub HomeToTopButton_Click()
    HomeToTop pauseOveride:=True
End Sub

Public Sub SampleDropOff(Optional pauseOverride As Boolean = False)
    If Prog_halted Then Exit Sub
    If Not Prog_paused Or Prog_halted Then
        lastMoveCommand = lastCmdDropoff
        lastMoveMotor = MotorUpDown
    End If
    PollMotor MotorUpDown
    ClearPollStatus MotorUpDown
    MoveMotor MotorUpDown, SampleBottom + 1.1 * SampleHeight, LiftSpeedSlow, True, pauseOverride
    ' (September 2007) check to see if the up/down switch is stuck
    If CheckInternalStatus(MotorUpDown, 4) = 1 And Not NOCOMM_MODE Then
        SetCodeLevel CodeRed
        frmSendMail.MailNotification "Switch Failure!", "Dropped off sample, but homing switch still set. Check for switch failure.", CodeRed
        MsgBox "Dropped off sample, but homing switch still set. Check for switch failure."
        SetCodeLevel StatusCodeColorLevelPrior, True
    End If
End Sub

Public Sub SamplePickup(Optional pauseOverride As Boolean = False)
    Dim currentPos As Long
    If Prog_halted Then Exit Sub
    If Not Prog_paused Or Prog_halted Then
        lastMoveCommand = lastCmdPickup
        lastMoveMotor = MotorUpDown
    End If
    SetTorques MotorUpDown, PickupTorqueThrottle * UpDownTorqueFactor, PickupTorqueThrottle * UpDownTorqueFactor, PickupTorqueThrottle * UpDownTorqueFactor, PickupTorqueThrottle * UpDownTorqueFactor
    MoveMotor MotorUpDown, SampleBottom, LiftSpeedSlow, True, pauseOverride
    currentPos = UpDownHeight
    MotorReset MotorUpDown
    Do While Abs(ReadPosition(MotorUpDown)) > 10
        DelayTime 0.05
    Loop
    RelabelPos MotorUpDown, currentPos
'    SetTorques MotorUpDown, UpDownTorqueFactor, UpDownTorqueFactor, UpDownTorqueFactor, UpDownTorqueFactor
    'MoveMotor MotorUpDown, currentPos + (currentPos - SampleBottom) * 0.3, LiftSpeedSlow, False, pauseOverride
        ' (September 2007) check to see if the up/down switch is stuck
    If CheckInternalStatus(MotorUpDown, 4) = 1 And Not NOCOMM_MODE Then
        SetCodeLevel CodeRed
        frmSendMail.MailNotification "Switch Failure!", "Quartz tube at sample top but homing switch still set. Check for switch failure.", CodeRed
        MsgBox "Quartz tube at sample top but homing switch still set. Check for switch failure."
        SetCodeLevel StatusCodeColorLevelPrior, True
    End If
End Sub

Private Sub SamplePickupButton_Click()
    SamplePickup pauseOverride:=True
End Sub

Private Sub SetTorques(motorid As Integer, ClosedHold As Integer, ClosedMove As Integer, OpenHold As Integer, OpenMove As Integer)
    'Set the appropriate torque limits
    'Assume 100% torque is 20000
    Dim PerTorque As Integer
    PerTorque = 200 'Value for 1% torque
    Dim CH As Integer
    Dim CM As Integer
    Dim OH As Integer
    Dim OM As Integer
    CH = CInt(ClosedHold) * PerTorque
    CM = CInt(ClosedMove) * PerTorque
    OH = CInt(OpenHold) * PerTorque
    OM = CInt(OpenMove) * PerTorque
    SendCommand motorid, (MotorAddress & "149 " + CStr(CH) + " " + CStr(CM) + " " + CStr(OH) + " " + CStr(OM))
    GetResponse motorid
End Sub

Private Sub ZeroTargetPos(motorid As Integer)
    'Zero target and position
    Dim dummy As Long
    SendCommand motorid, (MotorAddress & "145")
    GetResponse motorid
    dummy = ReadPosition(motorid)
End Sub

Private Sub ZeroTargetPosButton_Click()
    'Zero target and position
    ZeroTargetPos ActiveMotorControls
End Sub

Private Function ActiveMotorControls() As Integer
    Dim i As Integer
    ActiveMotorControls = 0
    For i = 1 To 3
        If optMotorActive(i) Then ActiveMotorControls = i
    Next i
End Function

Public Sub TurningMotorAngleOffset(ByVal angle As Double)
    TurningMotorRotate -angle
    ZeroTargetPos MotorTurning
End Sub
